<?php
header('Content-Type: application/json; charset=utf-8');
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $data = json_decode(file_get_contents("php://input"), true);
    if (!is_array($data)) $data = $_POST;

    if (
        empty($data["HomeNotice"]) &&
        empty($data["VersionCode"]) &&
        empty($data["UpdateLink"]) &&
        empty($data["UpdateNotice"]) &&
        empty($data["Application"]) &&
        empty($data["UpdatedOn"]) &&
        empty($data["ClosedReason"]) &&
        empty($data["ApiKey"]) &&
        empty($data["AddMoney"])
    ) {
        echo json_encode(["status" => "error", "message" => "At least one field is required"]);
        exit;
    }

    $HomeNotice   = trim($data["HomeNotice"]);
    $VersionCode  = trim($data["VersionCode"]);
    $UpdateLink   = trim($data["UpdateLink"]);
    $UpdateNotice = trim($data["UpdateNotice"]);
    $Application  = trim($data["Application"]);
    $UpdatedOn    = trim($data["UpdatedOn"]);
    $ClosedReason = trim($data["ClosedReason"]);
    $ApiKey       = trim($data["ApiKey"]);
    $AddMoney     = trim($data["AddMoney"]);

    $sql = "INSERT INTO `info` (
                `id`, `HomeNotice`, `VersionCode`, `UpdateLink`, `UpdateNotice`, 
                `Application`, `UpdatedOn`, `ClosedReason`, `ApiKey`, `AddMoney`
            ) VALUES (
                1, ?, ?, ?, ?, ?, ?, ?, ?, ?
            )
            ON DUPLICATE KEY UPDATE 
                `HomeNotice` = VALUES(`HomeNotice`),
                `VersionCode` = VALUES(`VersionCode`),
                `UpdateLink` = VALUES(`UpdateLink`),
                `UpdateNotice` = VALUES(`UpdateNotice`),
                `Application` = VALUES(`Application`),
                `UpdatedOn` = VALUES(`UpdatedOn`),
                `ClosedReason` = VALUES(`ClosedReason`),
                `ApiKey` = VALUES(`ApiKey`),
                `AddMoney` = VALUES(`AddMoney`),
                `created_at` = CURRENT_TIMESTAMP";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param(
        "sssssssss",
        $HomeNotice, $VersionCode, $UpdateLink, $UpdateNotice,
        $Application, $UpdatedOn, $ClosedReason, $ApiKey, $AddMoney
    );

    if ($stmt->execute()) {
        echo json_encode([
            "status" => "success",
            "message" => "Info saved successfully (always ID=1)",
            "id" => 1,
            "HomeNotice" => $HomeNotice,
            "VersionCode" => $VersionCode,
            "UpdateLink" => $UpdateLink,
            "UpdateNotice" => $UpdateNotice,
            "Application" => $Application,
            "UpdatedOn" => $UpdatedOn,
            "ClosedReason" => $ClosedReason,
            "ApiKey" => $ApiKey,
            "AddMoney" => $AddMoney
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Save failed",
            "error" => $stmt->error
        ]);
    }

    $stmt->close();
} 
else if ($_SERVER['REQUEST_METHOD'] === 'GET') {

    $result = $conn->query("SELECT * FROM `info` WHERE `id` = 1 LIMIT 1");

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo json_encode([
            "status" => "success",
            "id" => $row["id"],
            "HomeNotice" => $row["HomeNotice"],
            "VersionCode" => $row["VersionCode"],
            "UpdateLink" => $row["UpdateLink"],
            "UpdateNotice" => $row["UpdateNotice"],
            "Application" => $row["Application"],
            "UpdatedOn" => $row["UpdatedOn"],
            "ClosedReason" => $row["ClosedReason"],
            "ApiKey" => $row["ApiKey"],
            "AddMoney" => $row["AddMoney"],
            "created_at" => $row["created_at"]
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "No info found"
        ]);
    }
}

$conn->close();
?>