<?php
header('Content-Type: application/json; charset=utf-8');
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $data = json_decode(file_get_contents("php://input"), true);
    if (!is_array($data)) $data = $_POST;

    if (empty($data["MinimumDiposit"]) && empty($data["MinimumWithdraw"]) &&
        empty($data["ReferralBonus"]) && empty($data["ScrollNotice"])) {

        echo json_encode(["status" => "error", "message" => "At least one Minimum is required"]);
        exit;
    }

    $MinimumDiposit   = trim($data["MinimumDiposit"]);
    $MinimumWithdraw  = trim($data["MinimumWithdraw"]);
    $ReferralBonus    = trim($data["ReferralBonus"]);
    $ScrollNotice     = trim($data["ScrollNotice"]);

    $sql = "INSERT INTO `minimum` (`id`, `MinimumDiposit`, `MinimumWithdraw`, `ReferralBonus`, `ScrollNotice`) 
            VALUES (1, ?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE 
                `MinimumDiposit` = VALUES(`MinimumDiposit`),
                `MinimumWithdraw` = VALUES(`MinimumWithdraw`),
                `ReferralBonus` = VALUES(`ReferralBonus`),
                `ScrollNotice` = VALUES(`ScrollNotice`),
                `created_at` = CURRENT_TIMESTAMP";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssss", $MinimumDiposit, $MinimumWithdraw, $ReferralBonus, $ScrollNotice);

    if ($stmt->execute()) {
        echo json_encode([
            "status" => "success",
            "message" => "Minimum saved successfully (always ID=1)",
            "id" => 1,
            "MinimumDiposit" => $MinimumDiposit,
            "MinimumWithdraw" => $MinimumWithdraw,
            "ReferralBonus" => $ReferralBonus,
            "ScrollNotice" => $ScrollNotice
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Save failed",
            "error" => $stmt->error
        ]);
    }

    $stmt->close();
} 
else if ($_SERVER['REQUEST_METHOD'] === 'GET') {

    $result = $conn->query("SELECT * FROM `minimum` WHERE `id` = 1 LIMIT 1");

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo json_encode([
            "status" => "success",
            "id" => $row["id"],
            "MinimumDiposit" => $row["MinimumDiposit"],
            "MinimumWithdraw" => $row["MinimumWithdraw"],
            "ReferralBonus" => $row["ReferralBonus"],
            "ScrollNotice" => $row["ScrollNotice"],
            "created_at" => $row["created_at"]
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "No Minimum found"
        ]);
    }
}

$conn->close();
?>